<?php

class Consulta {

    private $db;

    public function __construct()
    {
        $this->db = new Database;
    }


    public function Tablero(){
    $this->db->query('SELECT * FROM tablero WHERE estatus="ACTIVO" order by fecha');
    $result = $this->db->resultSet();
    return $result;
    }

    public function Anulacion($nro){

    $this->db->startTransaction();

    $this->db->query('INSERT INTO pagos_nulos (id,cedula,fecha,mes,forma,periodo,referencia,banco,curso,inscripcion,monto,recibido,observa,created_at) SELECT id,cedula,fecha,mes,forma,periodo,referencia,banco,curso,inscripcion,monto,recibido,observa,created_at FROM pagos WHERE pagos.id = :id');
    $this->db->bind(':id', $nro);
    //$this->db->execute();
    $lastrec=$this->db->executelast();

    $this->db->query('UPDATE pagos_nulos SET anulado=:anulado WHERE id = :id');
    $this->db->bind(':id', $lastrec);
    $this->db->bind(':anulado', $_SESSION['user_id']);
    $this->db->execute();


    $this->db->query('DELETE FROM pagos WHERE id = :id');
    $this->db->bind(':id', $nro);
    $this->db->execute();

        if($this->db->submitTransaction()){
        return true;
        }else{
        return false;
        }
    }

    public function pagos_recibo($data){
    $this->db->query('SELECT pagos.*, alumnos.apellido,alumnos.nombre,alumnos.email,alumnos.celular FROM pagos INNER JOIN alumnos ON pagos.cedula = alumnos.cedula WHERE pagos.id=:id');
        $this->db->bind(':id', $data);
        $row0 = $this->db->single();
        if($this->db->rowCount() > 0){
        return $row0;
        }else{
        return false;
        }
    }    

    public function Consultas_pag_ins($fechas){
    $f1 = explode("*", $fechas);
    $this->db->query('SELECT pagos.*, alumnos.apellido,alumnos.nombre,alumnos.email,alumnos.celular FROM pagos INNER JOIN alumnos ON pagos.cedula = alumnos.cedula WHERE DATE_FORMAT(pagos.created_at, "%Y-%m-%d")>=:f1 and DATE_FORMAT(pagos.created_at, "%Y-%m-%d")<=:f2 and pagos.inscripcion>0 ORDER BY pagos.id');
    $this->db->bind(':f1', $f1[0]);
    $this->db->bind(':f2', $f1[1]);
    $result = $this->db->resultSet();
    return $result;
    }

    public function Consultas_vta($fechas){
    $f1 = explode("*", $fechas);
//    $this->db->query('SELECT pagos.*, alumnos.apellido,alumnos.nombre,alumnos.email,alumnos.celular FROM pagos INNER JOIN alumnos ON pagos.cedula = alumnos.cedula WHERE DATE_FORMAT(pagos.created_at, "%Y-%m-%d")>=:f1 and DATE_FORMAT(pagos.created_at, "%Y-%m-%d")<=:f2 ORDER BY alumnos.apellido,alumnos.nombre');

    $this->db->query('SELECT ventas.id, clientes.nombre, clientes.apellido, conceptos.conceptos, ventas.fecha,ventas.forma, ventas.delivery, ventas.monto
FROM (ventas INNER JOIN clientes ON ventas.id_cliente = clientes.id) INNER JOIN conceptos ON ventas.forma = conceptos.id  WHERE DATE_FORMAT(ventas.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(ventas.fecha, "%Y-%m-%d")<=:f2
ORDER BY ventas.id DESC');

    $this->db->bind(':f1', $f1[0]);
    $this->db->bind(':f2', $f1[1]);
    $result = $this->db->resultSet();
    return $result;
    }

    public function Consultas_pase($fechas){
    $f1 = explode("*", $fechas);
    //$this->db->query('SELECT * FROM pases WHERE DATE_FORMAT(created_at, "%Y-%m-%d")>=:f1 and DATE_FORMAT(created_at, "%Y-%m-%d")<=:f2 ORDER BY alumno');

    $this->db->query('SELECT pases.*, materias.materia FROM pases,materias WHERE pases.materia = materias.id and DATE_FORMAT(pases.created_at, "%Y-%m-%d")>=:f1 and DATE_FORMAT(pases.created_at, "%Y-%m-%d")<=:f2 ORDER BY pases.created_at desc,pases.alumno asc');
    $this->db->bind(':f1', $f1[0]);
    $this->db->bind(':f2', $f1[1]);
    $result = $this->db->resultSet();
    return $result;
    }

    public function Consultas_pag_inf($fechas){
    $f1 = explode("*", $fechas);

$this->db->query('SELECT especialidades.especialidad, Sum(pagos.monto) AS SumaDemonto
FROM pagos INNER JOIN (cursos INNER JOIN especialidades ON cursos.id_especialidad = especialidades.id) ON pagos.curso = cursos.curso
WHERE DATE_FORMAT(pagos.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(pagos.fecha, "%Y-%m-%d")<=:f2 GROUP BY especialidades.especialidad');

//    $this->db->query('SELECT pagos.*, alumnos.apellido,alumnos.nombre,alumnos.email,alumnos.celular FROM pagos INNER JOIN alumnos ON pagos.cedula = alumnos.cedula WHERE DATE_FORMAT(pagos.created_at, "%Y-%m-%d")>=:f1 and DATE_FORMAT(pagos.created_at, "%Y-%m-%d")<=:f2 ORDER BY alumnos.apellido,alumnos.nombre');
    $this->db->bind(':f1', $f1[0]);
    $this->db->bind(':f2', $f1[1]);
    $result = $this->db->resultSet();
    return $result;
    }





    public function Consultas_pag_nulos($fechas){
    $f1 = explode("*", $fechas);
    $this->db->query('SELECT pagos_nulos.*, alumnos.apellido,alumnos.nombre,alumnos.email,alumnos.celular FROM pagos_nulos INNER JOIN alumnos ON pagos_nulos.cedula = alumnos.cedula WHERE DATE_FORMAT(pagos_nulos.delete_at, "%Y-%m-%d")>=:f1 and DATE_FORMAT(pagos_nulos.delete_at, "%Y-%m-%d")<=:f2 ORDER BY alumnos.apellido,alumnos.nombre');
    $this->db->bind(':f1', $f1[0]);
    $this->db->bind(':f2', $f1[1]);
    $result = $this->db->resultSet();
    return $result;
    }

    public function Consultas_pag0($fechas){
    //$f1 = explode("*", $fechas);
    $this->db->query('SELECT pagos.*, alumnos.apellido,alumnos.nombre,alumnos.email,alumnos.celular FROM pagos INNER JOIN alumnos ON pagos.cedula = alumnos.cedula WHERE DATE_FORMAT(pagos.created_at, "%Y-%m-%d")=:f1 ORDER BY alumnos.apellido,alumnos.nombre');
    $this->db->bind(':f1', $fechas);
    $result = $this->db->resultSet();
    return $result;
    }



    public function Consultas($fecha){
    $this->db->query('SELECT pagos.*, alumnos.apellido,alumnos.nombre FROM pagos INNER JOIN alumnos ON pagos.cedula = alumnos.cedula WHERE DATE_FORMAT(pagos.created_at, "%Y-%m-%d")="'.$fecha.'" ORDER BY pagos.id');
    $result = $this->db->resultSet();
    return $result;
    }

    public function Alumnos(){
    $this->db->query('SELECT * FROM alumnos ORDER BY apellido,nombre');
    $result = $this->db->resultSet();
    return $result;
    }

    public function importardo($nro){
    $this->db->query('SELECT * FROM temp_curso Where curso=:curso');
    $this->db->bind(':curso', $nro);
    $result = $this->db->resultSet();
    //var_dump($result);

        $this->db->query('INSERT INTO alumnos (cedula,nombre,apellido,email,celular) VALUES (:cedula,:nombre,:apellido,:email,:celular)');
        foreach ($result as $p){
        $a=$p->cedula;
        $b=$p->nombre;
        $c=$p->apellido;
        $d=$p->correo;
        $e=$p->celular;
        $f=$p->curso;

        $this->db->bind(':cedula', $a);
        $this->db->bind(':nombre', $b);
        $this->db->bind(':apellido', $c);
        $this->db->bind(':email', $d);
        $this->db->bind(':celular', $e);

        $this->db->execute();
        }

        $this->db->query('INSERT INTO alumnos_cursos (cedula,alumno,curso) VALUES (:cedula,:alumno,:curso)');
        foreach ($result as $p){
        $a=$p->cedula;
        $b=$p->nombre;
        $c=$p->apellido;
        $f=$p->curso;

        $this->db->bind(':cedula', $a);
        $this->db->bind(':alumno', $c.' '.$b);
        $this->db->bind(':curso', $f);

        $this->db->execute();
        }
        return true;
    }

}