<?php
class Venta {
    private $db;
    public function __construct()
    {
        $this->db = new Database;
    }

public function Ventas_Anular($no){
    $this->db->query('INSERT INTO ventas_det_nulos SELECT * FROM ventas_det WHERE id_factura=:id');
    $this->db->bind(':id', $no);
    $this->db->execute();

    $this->db->query('INSERT INTO ventas_nulos (id,id_cliente,fecha,pago,forma,delivery,monto,observacion,created) SELECT id,id_cliente,fecha,pago,forma,delivery,monto,observacion,CURRENT_DATE FROM ventas WHERE id=:id');
    $this->db->bind(':id', $no);
    $this->db->execute();

    $this->db->query('DELETE FROM ventas WHERE id=:id');
    $this->db->bind(':id', $no);
    $this->db->execute();

    $this->db->query('DELETE FROM ventas_det WHERE id_factura=:id');
    $this->db->bind(':id', $no);
    $this->db->execute();

/*         if($this->db->execute()){
        //return true;
        }else{
        return false;
        }*/

}


public function Ventas_Act_Pg(){
$this->db->query('SELECT id,forma,monto from ventas order by id');
//$this->db->bind(':nro', $no);
$resultas = $this->db->resultSet();
//var_dump($resultas);
//return $resultas;

foreach ($resultas as $prx){

$this->db->query('INSERT INTO ventas_pagos (id_factura,id_forma,monto) VALUES (:id_factura,:id_forma,:monto)');
    $this->db->bind(':id_factura', $prx->id);
    $this->db->bind(':id_forma', $prx->forma);
    $this->db->bind(':monto', $prx->monto);
    $this->db->execute();

}
echo "Listo";

}

    public function Ventas_Buscar_pago($no){
    $this->db->query('SELECT ventas_pagos.*, conceptos.conceptos
FROM ventas_pagos INNER JOIN conceptos ON ventas_pagos.id_forma = conceptos.id
WHERE ventas_pagos.id_factura=:nro');
    $this->db->bind(':nro', $no);
    $resultas = $this->db->resultSet();
    return $resultas;
    }

    public function Ventas_Buscar($no){
    $this->db->query('SELECT ventas.*, clientes.nombre, clientes.apellido, clientes.direccion, clientes.rif, vendedores.nombre as vende1, vendedores.apellido as vende2
FROM (ventas INNER JOIN clientes ON ventas.id_cliente = clientes.id) INNER JOIN vendedores ON ventas.vendedor = vendedores.rif
WHERE ventas.id=:nro');
    $this->db->bind(':nro', $no);
    $row = $this->db->single();
        //check the row
        if($this->db->rowCount() > 0){
            return $row;
        }else{
            return false;
        }
    }

    public function Ventas_Buscar_Gral(){
    $this->db->query('SELECT ventas.*, clientes.nombre, clientes.apellido, clientes.direccion, clientes.rif, vendedores.nombre as vende1, vendedores.apellido as vende2
FROM (ventas INNER JOIN clientes ON ventas.id_cliente = clientes.id) INNER JOIN vendedores ON ventas.vendedor = vendedores.rif WHERE ventas.saldo>0 Order by ventas.fecha');
    //$this->db->bind(':nro', $no);
    $resultas = $this->db->resultSet();
    return $resultas;
    }


    public function Ventas_Buscar_det($no){
    $this->db->query('SELECT ventas_det.*, productos.producto, productos.orden, productos.presentacion
FROM ventas_det INNER JOIN productos ON ventas_det.id_producto = productos.id
WHERE ventas_det.id_factura=:nro ORDER BY productos.producto');
    $this->db->bind(':nro', $no);
    $resultas = $this->db->resultSet();
    return $resultas;
    }

public function Guardar_venta($data){
    $this->db->query('SELECT * from productos order by orden');
    $resultas = $this->db->resultSet();

    //var_dump($resultas);
    //exit;
if($data['fact_head'][0]['forma']=='CONTADO'){
    $saldo=0;
}else{
    $saldo=$data['fact_head'][0]['totales'];
}


        $this->db->query('INSERT INTO ventas (id_cliente,fecha,pago,forma,vendedor,monto,saldo,observacion) VALUES (:id_cliente,:fecha,:pago,:forma,:vendedor,:monto,:saldo,:observacion)');
        $this->db->bind(':id_cliente', $data['fact_head'][0]['cliente']);
        $this->db->bind(':fecha', $data['fact_head'][0]['fecha']);
        $this->db->bind(':pago', $data['fact_head'][0]['pago']);
        $this->db->bind(':forma', $data['fact_head'][0]['forma']);
        $this->db->bind(':vendedor', $data['fact_head'][0]['vendedor']);
        $this->db->bind(':monto', $data['fact_head'][0]['totales']);
        $this->db->bind(':saldo', $saldo);
        $this->db->bind(':observacion', $data['fact_head'][0]['observa']);
        $lastrec=$this->db->executelast();
        //if($this->db->execute()){
        if($lastrec>0){
        //$array["res"] = "ok";
        //$array["msg"] = $lastrec;
        //return $array;
        }else{
        $array["res"] = "error";
        $array["msg"] = "ERROR EN ALUMNOS...3";
        //return $array;
        }
//var_dump($array);
//exit;

if($data['fact_head'][0]['forma']=='CONTADO'){
$this->db->query('INSERT INTO ventas_pagos (id_factura,id_forma,monto) VALUES (:id_factura,:id_forma,:monto)');

for ($i = 0; $i < count($data['fact_pago']); $i++) {
//echo '--->'.$i."\n";
$pago = $data['fact_pago'][$i];

    $this->db->bind(':id_factura', $lastrec);
    $this->db->bind(':id_forma', $pago[0]);
    $this->db->bind(':monto', $pago[1]);
    $resp02=$this->db->execute();
        if($resp02){
        //$array["res"] = "ok";
        //$array["msg"] = $lastrec;
        //return $array;
        }else{
        $array["res"] = "error";
        $array["msg"] = "ERROR EN ALUMNOS...99333";
        //return $array;
        }
}
}

//var_dump($data['fact_prod']);
//exit;


for ($i = 0; $i < count($data['fact_prod']); $i++) {
//echo '--->'.$i."\n";
$clase = $data['fact_prod'][$i];
// Se hace loop con el objeto

//    print "$clave => $valor\n";
$costo=0;
foreach ($resultas as $pr){
if($clase['id_producto']==$pr->id){
   $costo=$pr->costo;
   $inventario=$pr->inventario;
   break;
}
}
$this->db->query('INSERT INTO ventas_det (id_factura,id_producto,fecha,cantidad,costo,precio,monto) VALUES (:id_factura,:id_producto,:fecha,:cantidad,:costo,:precio,:monto)');
    $this->db->bind(':id_factura', $lastrec);
    $this->db->bind(':id_producto', $clase['id_producto']);
    $this->db->bind(':fecha', $data['fact_head'][0]['fecha']);
    $this->db->bind(':cantidad', $clase['cantidad']);
    $this->db->bind(':costo', $costo);
    $this->db->bind(':precio', $clase['precio']);
    $this->db->bind(':monto', $clase['totales']);
    $resp00=$this->db->execute();
        if($resp00){
        //$array["res"] = "ok";
        //$array["msg"] = $lastrec;
        //return $array;
        }else{
        $array["res"] = "error";
        $array["msg"] = "ERROR EN ALUMNOS...333";
        //return $array;
        }



    $saldo_inv=$inventario-$clase['cantidad'];
$this->db->query('UPDATE productos SET inventario=:cantidad WHERE id=:id_producto');
    $this->db->bind(':id_producto', $clase['id_producto']);
    $this->db->bind(':cantidad', $saldo_inv);
    //$this->db->execute();
    $resp01=$this->db->execute();
        if($resp01){
        //$array["res"] = "ok";
        //$array["msg"] = $lastrec;
        //return $array;
        }else{
        $array["res"] = "error";
        $array["msg"] = "ERROR EN ALUMNOS...33344";
        //return $array;
        }
}

        if($lastrec>0){
        $array["res"] = "ok";
        $array["msg"] = $lastrec;
        return $array;
        }else{
        $array["res"] = "error";
        $array["msg"] = "ERROR EN ALUMNOS...3";
        return $array;
        }

}

public function Guardar_venta_pago($data){


$this->db->query('INSERT INTO ventas_pagos (id_factura,id_forma,monto) VALUES (:id_factura,:id_forma,:monto)');

for ($i = 0; $i < count($data['fact_pago']); $i++) {
$pago = $data['fact_pago'][$i];

    $this->db->bind(':id_factura', $data['id_pago']);
    $this->db->bind(':id_forma', $pago[0]);
    $this->db->bind(':monto', $pago[1]);
    $this->db->execute();

}

$this->db->query('UPDATE ventas SET saldo=0 WHERE id=:id_factura');
    $this->db->bind(':id_factura', $data['id_pago']);
    $this->db->execute();




        $array["res"] = "ok";
        $array["msg"] = "";
        return $array;

}


    public function getEstado(){
    $this->db->query('SELECT * from estados order by estado');
    $result = $this->db->resultSet();
    return $result;
    }

    public function Venta_index(){
/*    $this->db->query('SELECT ventas.id, clientes.nombre, clientes.apellido, conceptos.conceptos, ventas.fecha,ventas.forma, ventas.delivery, ventas.monto
FROM (ventas INNER JOIN clientes ON ventas.id_cliente = clientes.id) INNER JOIN conceptos ON ventas.forma = conceptos.id
ORDER BY ventas.id DESC limit 0,250');*/
    $this->db->query('SELECT ventas.id, clientes.nombre, clientes.apellido, ventas.fecha,ventas.forma, ventas.delivery, ventas.monto, ventas.saldo
FROM (ventas INNER JOIN clientes ON ventas.id_cliente = clientes.id) ORDER BY ventas.id DESC limit 0,250');
    $result = $this->db->resultSet();
    return $result;
    }

    public function Venta_ver_pago(){
    $this->db->query('SELECT * from ventas_pagos order by id_factura desc limit 0,400');
    $result = $this->db->resultSet();
    return $result;
    }

    public function Venta_Consulta($fechas){
    $f1 = explode("*", $fechas);
//print_r($f1);
//exit;
if($f1[3]=="TODOS"){
$this->db->query('SELECT ventas.id, clientes.nombre, clientes.apellido, ventas.fecha,ventas.forma, ventas.delivery, ventas.monto,ventas.pago
FROM (ventas INNER JOIN clientes ON ventas.id_cliente = clientes.id)   WHERE DATE_FORMAT(ventas.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(ventas.fecha, "%Y-%m-%d")<=:f2
ORDER BY ventas.fecha');
}else{
$this->db->query('SELECT ventas.id, clientes.nombre, clientes.apellido, ventas.fecha,ventas.forma, ventas.delivery, ventas.monto,ventas.pago
FROM (ventas INNER JOIN clientes ON ventas.id_cliente = clientes.id)  WHERE DATE_FORMAT(ventas.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(ventas.fecha, "%Y-%m-%d")<=:f2 and ventas.pago=:rango
ORDER BY ventas.fecha');
$this->db->bind(':rango', $f1[3]);
}

    $this->db->bind(':f1', $f1[0]);
    $this->db->bind(':f2', $f1[1]);
    $result = $this->db->resultSet();
    return $result;
    }

    public function Venta_Consultadet($fechas){
    $f1 = explode("*", $fechas);
//    $this->db->query('SELECT pagos.*, alumnos.apellido,alumnos.nombre,alumnos.email,alumnos.celular FROM pagos INNER JOIN alumnos ON pagos.cedula = alumnos.cedula WHERE DATE_FORMAT(pagos.created_at, "%Y-%m-%d")>=:f1 and DATE_FORMAT(pagos.created_at, "%Y-%m-%d")<=:f2 ORDER BY alumnos.apellido,alumnos.nombre');

    $this->db->query('SELECT ventas_det.id_factura, productos.producto,productos.orden, ventas_det.fecha, ventas_det.precio, ventas_det.cantidad , ventas_det.costo
FROM ventas_det INNER JOIN productos ON ventas_det.id_producto = productos.id
WHERE DATE_FORMAT(ventas_det.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(ventas_det.fecha, "%Y-%m-%d")<=:f2
ORDER BY productos.orden');

    $this->db->bind(':f1', $f1[0]);
    $this->db->bind(':f2', $f1[1]);
    $result = $this->db->resultSet();
    return $result;
    }

    public function Gastos_Consulta($fechas){
    $f1 = explode("*", $fechas);
//    $this->db->query('SELECT pagos.*, alumnos.apellido,alumnos.nombre,alumnos.email,alumnos.celular FROM pagos INNER JOIN alumnos ON pagos.cedula = alumnos.cedula WHERE DATE_FORMAT(pagos.created_at, "%Y-%m-%d")>=:f1 and DATE_FORMAT(pagos.created_at, "%Y-%m-%d")<=:f2 ORDER BY alumnos.apellido,alumnos.nombre');

    $this->db->query('SELECT * FROM gastos  WHERE DATE_FORMAT(fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(fecha, "%Y-%m-%d")<=:f2 ORDER BY fecha');

    $this->db->bind(':f1', $f1[0]);
    $this->db->bind(':f2', $f1[1]);
    $result = $this->db->resultSet();
    return $result;
    }

public function Venta_forma($fechas){
$f1 = explode("*", $fechas);

if($f1[3]=="TODOS"){
$this->db->query('SELECT conceptos.conceptos,conceptos.orden, Sum(ventas_pagos.monto) AS SumaDemonto
FROM (ventas INNER JOIN ventas_pagos ON ventas.id = ventas_pagos.id_factura) INNER JOIN conceptos ON ventas_pagos.id_forma = conceptos.id
WHERE DATE_FORMAT(ventas.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(ventas.fecha, "%Y-%m-%d")<=:f2
GROUP BY conceptos.conceptos,conceptos.orden
ORDER BY conceptos.orden');
}else{
$this->db->query('SELECT conceptos.conceptos,conceptos.orden, Sum(ventas_pagos.monto) AS SumaDemonto
FROM (ventas INNER JOIN ventas_pagos ON ventas.id = ventas_pagos.id_factura) INNER JOIN conceptos ON ventas_pagos.id_forma = conceptos.id
WHERE DATE_FORMAT(ventas.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(ventas.fecha, "%Y-%m-%d")<=:f2  and ventas.pago=:rango
GROUP BY conceptos.conceptos,conceptos.orden
ORDER BY conceptos.orden');
$this->db->bind(':rango', $f1[3]);
}

$this->db->bind(':f1', $f1[0]);
$this->db->bind(':f2', $f1[1]);
$result = $this->db->resultSet();
return $result;
}

public function Venta_balance_gastos($fechas){
$f1 = explode("*", $fechas);

$this->db->query('SELECT gastos.gasto, Sum(gastos.monto) AS SumaDemonto FROM gastos
WHERE DATE_FORMAT(gastos.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(gastos.fecha, "%Y-%m-%d")<=:f2
GROUP BY gastos.gasto ORDER BY gastos.gasto');

$this->db->bind(':f1', $f1[0]);
$this->db->bind(':f2', $f1[1]);
$result = $this->db->resultSet();
return $result;
}

public function Venta_balance_ingresos($fechas){
$f1 = explode("*", $fechas);

if($f1[3]=="TODOS"){
$this->db->query('SELECT Sum(ventas.monto) AS SumaDeIng FROM ventas
WHERE DATE_FORMAT(ventas.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(ventas.fecha, "%Y-%m-%d")<=:f2');
}else{
$this->db->query('SELECT Sum(ventas.monto) AS SumaDeIng FROM ventas
WHERE DATE_FORMAT(ventas.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(ventas.fecha, "%Y-%m-%d")<=:f2 AND ventas.pago=:rango');
$this->db->bind(':rango', $f1[3]);
}

$this->db->bind(':f1', $f1[0]);
$this->db->bind(':f2', $f1[1]);
$result = $this->db->resultSet();
return $result;
}



public function Venta_cant($fechas){
$f1 = explode("*", $fechas);
/*SELECT productos.producto, ventas_det.id_producto, Sum(ventas_det.cantidad) AS SumaDecantidad, Sum(ventas_det.monto) AS SumaDemonto
FROM (ventas_det INNER JOIN productos ON ventas_det.id_producto = productos.id) INNER JOIN ventas ON ventas_det.id_factura = ventas.id
WHERE (((ventas.fecha)>=#1/1/2020# And (ventas.fecha)<=#1/1/2025#))
GROUP BY productos.producto, ventas_det.id_producto
ORDER BY productos.producto;
*/

if($f1[3]=="TODOS"){
$this->db->query('SELECT productos.producto,productos.orden, ventas_det.id_producto, Sum(ventas_det.cantidad) AS SumaDecantidad, Sum(ventas_det.monto) AS SumaDemonto
FROM (ventas_det INNER JOIN productos ON ventas_det.id_producto = productos.id) INNER JOIN ventas ON ventas_det.id_factura = ventas.id
WHERE DATE_FORMAT(ventas.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(ventas.fecha, "%Y-%m-%d")<=:f2
GROUP BY productos.producto, ventas_det.id_producto,productos.orden
ORDER BY productos.orden');
}else{
$this->db->query('SELECT productos.producto,productos.orden, ventas_det.id_producto, Sum(ventas_det.cantidad) AS SumaDecantidad, Sum(ventas_det.monto) AS SumaDemonto, ventas.pago
FROM (ventas_det INNER JOIN productos ON ventas_det.id_producto = productos.id) INNER JOIN ventas ON ventas_det.id_factura = ventas.id
WHERE DATE_FORMAT(ventas.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(ventas.fecha, "%Y-%m-%d")<=:f2
GROUP BY productos.producto, ventas_det.id_producto, ventas.pago,productos.orden
HAVING ventas.pago=:rango ORDER BY productos.orden');
$this->db->bind(':rango', $f1[3]);
}

$this->db->bind(':f1', $f1[0]);
$this->db->bind(':f2', $f1[1]);
$result = $this->db->resultSet();
return $result;
}


public function Venta_mes($fechas){
$f1 = explode("*", $fechas);

if($f1[3]=="TODOS"){
$this->db->query('SELECT ventas_det.id_producto, Month(ventas_det.fecha) AS mes, Sum(ventas_det.cantidad) AS SumaDecantidad
FROM ventas_det INNER JOIN ventas ON ventas_det.id_factura = ventas.id
WHERE DATE_FORMAT(ventas.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(ventas.fecha, "%Y-%m-%d")<=:f2
GROUP BY ventas_det.id_producto, Month(ventas_det.fecha)
ORDER BY ventas_det.id_producto, Month(ventas_det.fecha)');
}else{
$this->db->query('SELECT ventas_det.id_producto, Month(ventas_det.fecha) AS mes, Sum(ventas_det.cantidad) AS SumaDecantidad, ventas.pago
FROM ventas_det INNER JOIN ventas ON ventas_det.id_factura = ventas.id
WHERE DATE_FORMAT(ventas.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(ventas.fecha, "%Y-%m-%d")<=:f2
GROUP BY ventas_det.id_producto, Month(ventas_det.fecha), ventas.pago
HAVING ventas.pago=:rango
ORDER BY ventas_det.id_producto, Month(ventas_det.fecha)');
$this->db->bind(':rango', $f1[3]);
}

$this->db->bind(':f1', $f1[0]);
$this->db->bind(':f2', $f1[1]);
$result = $this->db->resultSet();
return $result;
}

public function Venta_regalo($fechas){
$f1 = explode("*", $fechas);

/*$this->db->query('SELECT ventas.forma, ventas_det.id_producto, productos.producto, Sum(ventas_det.cantidad) AS SumaDecantidad, Sum(ventas_det.cantidad*ventas_det.costo) AS totalesv FROM ventas INNER JOIN (ventas_det INNER JOIN productos ON ventas_det.id_producto = productos.id) ON ventas.id = ventas_det.id_factura
WHERE DATE_FORMAT(ventas_det.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(ventas_det.fecha, "%Y-%m-%d")<=:f2
GROUP BY ventas.forma, ventas_det.id_producto, productos.producto
HAVING ventas.forma=3 ORDER BY productos.producto');*/

if($f1[3]=="TODOS"){
$this->db->query('SELECT ventas.forma, ventas_det.id_producto, productos.producto,productos.orden, Sum(ventas_det.cantidad) AS SumaDecantidad, Sum(ventas_det.cantidad*ventas_det.costo) AS totalesv
FROM ventas INNER JOIN (ventas_det INNER JOIN productos ON ventas_det.id_producto = productos.id) ON ventas.id = ventas_det.id_factura
WHERE DATE_FORMAT(ventas.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(ventas.fecha, "%Y-%m-%d")<=:f2
GROUP BY ventas.forma, ventas_det.id_producto, productos.producto,productos.orden
HAVING ventas.forma=3 ORDER BY productos.orden');
}else{
$this->db->query('SELECT ventas.forma, ventas_det.id_producto, productos.producto,productos.orden, Sum(ventas_det.cantidad) AS SumaDecantidad, Sum(ventas_det.cantidad*ventas_det.costo) AS totalesv, ventas.pago
FROM ventas INNER JOIN (ventas_det INNER JOIN productos ON ventas_det.id_producto = productos.id) ON ventas.id = ventas_det.id_factura
WHERE DATE_FORMAT(ventas.fecha, "%Y-%m-%d")>=:f1 and DATE_FORMAT(ventas.fecha, "%Y-%m-%d")<=:f2
GROUP BY ventas.forma, ventas_det.id_producto, productos.producto, ventas.pago,productos.orden
HAVING ventas.forma=3 AND ventas.pago=:rango ORDER BY productos.orden');
$this->db->bind(':rango', $f1[3]);
}


$this->db->bind(':f1', $f1[0]);
$this->db->bind(':f2', $f1[1]);
$result = $this->db->resultSet();
return $result;
}

public function Venta_acumula(){
/*$ymes = date("Y");
$mes = date("n");
$inicio=$ymes."-".$mes."-1";
if($mes==12){
$ymes++;
$mes=1;
}else{
$mes++;
}
$fin=$ymes."-".$mes."-1";
$final=date("Y-m-d",strtotime($fin."- 1 days"));

echo $inicio.' '.$final;*/
//exit;

$rango=rango_fecha();
//var_dump($rango['inicio']);
//exit;

$this->db->query('SELECT Sum(ventas_det.cantidad) AS SumaDecantidad FROM ventas_det WHERE ventas_det.fecha>=:inicio And ventas_det.fecha<=:final');
$this->db->bind(':inicio', $rango['inicio']);
$this->db->bind(':final', $rango['final']);
    $row = $this->db->single();
        if($this->db->rowCount() > 0){
            return $row->SumaDecantidad;
        }else{
            return 0;
        }
}

public function Venta_contar_tablero(){

$this->db->query('SELECT count(ventas.id) AS SumaDecantidad FROM ventas WHERE ventas.saldo>=0');
    $row = $this->db->single();
        if($this->db->rowCount() > 0){
            $array["res"] = $row->SumaDecantidad;
            return $array;
        }else{
            return 0;
        }
}

public function Venta_contar(){
$rango=rango_fecha();

$this->db->query('SELECT count(ventas.id) AS SumaDecantidad FROM ventas WHERE ventas.fecha>=:inicio And ventas.fecha<=:final');
$this->db->bind(':inicio', $rango['inicio']);
$this->db->bind(':final', $rango['final']);
    $row = $this->db->single();
        if($this->db->rowCount() > 0){
            return $row->SumaDecantidad;
        }else{
            return 0;
        }
}

public function Venta_contar_reg(){
$rango=rango_fecha();

$this->db->query('SELECT ventas.forma, Sum(ventas_det.cantidad) AS SumaDecantidad
FROM ventas INNER JOIN (ventas_det INNER JOIN productos ON ventas_det.id_producto = productos.id) ON ventas.id = ventas_det.id_factura
WHERE ventas_det.fecha>=:inicio And ventas_det.fecha<=:final GROUP BY ventas.forma HAVING ventas.forma=3');
$this->db->bind(':inicio', $rango['inicio']);
$this->db->bind(':final', $rango['final']);
    $row = $this->db->single();
        if($this->db->rowCount() > 0){
            return $row->SumaDecantidad;
        }else{
            return 0;
        }
}

public function act_costos(){
$this->db->query('SELECT * FROM productos order by orden');
$resultxxx = $this->db->resultSet();

foreach ($resultxxx as $pr){
echo $pr->id.'-'.$pr->producto.'-'.$pr->costo.'<br>';

$this->db->query('UPDATE ventas_det SET costo=:costo WHERE id_producto=:id');
$this->db->bind(':id', $pr->id);
$this->db->bind(':costo', $pr->costo);
$res=$this->db->execute();
        if($res){
        echo $pr->producto.' - Ok <br>';
        }else{
        echo $pr->producto.' - Error <br>';
        }
}

exit;

}


}